
#include <struct.h>
#include "affector.h"
#include "LinkedList.h"

#define   RESTORE_NONE          0x0001
#define   RESTORE_AS_IS         0x0002
#define   RESTORE_RELATIVE      0x0004

typedef struct
{
  char*         strName;
  char*         strParent;
  tMATRIX       matrix;
  DWORD         dwKind;
}t_matHodler;

t_matHodler*    g_pMatHolder;

DWORD CALLBACK AffectorMM(tProcParams* pParams)
{
  long res = 0;
  int i, pos;
  if (CurrentState.IsMultyMode())
    return 0;

  for (i = 0; i < pParams->Objects->ObjAmount; i++)
  {
    if (pParams->Objects->ObjSet[i].Marked() &&
        pParams->Objects->ObjSet[i].AllowGenericEdit())
    {//mark all indirect children;
      for (pos = 0; pos < pParams->Objects->ObjAmount; pos++)
        if ((pos!=i) &&
            IsIndirectChild(
                g_pHList, 
                pParams->Objects->ObjSet[pos].ObjectName,
                pParams->Objects->ObjSet[i].ObjectName))
        {//child activation
          pParams->Objects->ObjSet[pos].Mark();
          pParams->Objects->ObjSet[pos].nRequire |= (res = Z3D_PLUGRESULT_UPDATEWIRE);
        }
    }
  }
  return (res == 0) ? 0 : Z3D_PLUGRESULT_VIEWSREDRAW;
}



DWORD CALLBACK AffectorBD(tProcParams* pParams)
{
  if (CurrentState.IsMultyMode())
    return 0;
  int i, pos;

  if (g_pMatHolder)
  {
    pos = 0;
    while (g_pMatHolder[pos++].strName)
    {
      if (g_pMatHolder[pos-1].strParent)
        free(g_pMatHolder[pos-1].strParent);
      free(g_pMatHolder[pos-1].strName);
    }
    delete[] g_pMatHolder;
    g_pMatHolder = NULL;
  }

  g_pMatHolder = new t_matHodler[pParams->Objects->ObjAmount+1];
  for (i = 0; i < pParams->Objects->ObjAmount; i++)
  {
    g_pMatHolder[i].strName = strdup(pParams->Objects->ObjSet[i].ObjectName);
    g_pMatHolder[i].strParent = NULL;
    g_pMatHolder[i].matrix = pParams->Objects->ObjSet[i].mTransform;
    g_pMatHolder[i].dwKind = RESTORE_NONE;
  }
  for (i = 0; i < pParams->Objects->ObjAmount; i++)
  {
    if (pParams->Objects->ObjSet[i].Marked() &&
        pParams->Objects->ObjSet[i].AllowGenericEdit())
    {//mark all indirect children;
      tMATRIX mInvParent;
      MatrixInvert(mInvParent, pParams->Objects->ObjSet[i].mTransform);
      for (pos = 0; pos < pParams->Objects->ObjAmount; pos++)
        if ((pos!=i) &&
            IsIndirectChild(
                g_pHList, 
                pParams->Objects->ObjSet[pos].ObjectName,
                pParams->Objects->ObjSet[i].ObjectName))
        {//child matrix incapsulation
          MatrixMultiply(g_pMatHolder[pos].matrix,  mInvParent, pParams->Objects->ObjSet[pos].mTransform);
          g_pMatHolder[pos].dwKind  = RESTORE_RELATIVE;
          g_pMatHolder[pos].strParent = strdup(pParams->Objects->ObjSet[i].ObjectName);
          pParams->Objects->ObjSet[pos].mTransform = pParams->Objects->ObjSet[i].mTransform;
        }
    }
  }
  g_pMatHolder[pParams->Objects->ObjAmount].strName = NULL;
  return 0;
}



DWORD CALLBACK AffectorBU(tProcParams* pParams)
{
  if (!g_pMatHolder)
    return 0;
  int i, pos;
  //
  //:FIXME:restore as_is matrixes first!!
  //
  for (i = 0; i < pParams->Objects->ObjAmount; i++)
  {
    pos = 0;
    while (g_pMatHolder[pos++].strName)
      if (!strcmp(g_pMatHolder[pos-1].strName, pParams->Objects->ObjSet[i].ObjectName))
      {
        if (g_pMatHolder[pos-1].dwKind == RESTORE_AS_IS)
          pParams->Objects->ObjSet[i].mTransform = g_pMatHolder[pos-1].matrix;
        else
        if ((g_pMatHolder[pos-1].dwKind == RESTORE_RELATIVE) &&
            g_pMatHolder[pos-1].strParent)
        {//find parent and restore relatively;
          for (int par = 0; par < pParams->Objects->ObjAmount; par++)
            if (!strcmp(g_pMatHolder[pos-1].strParent, pParams->Objects->ObjSet[par].ObjectName))
            {
              MatrixMultiply(
                    pParams->Objects->ObjSet[i].mTransform,
                    pParams->Objects->ObjSet[par].mTransform,
                    g_pMatHolder[pos-1].matrix);
              break;
            }
        }
        break;
      }
  }
  //delete holder;
  pos = 0;
  while (g_pMatHolder[pos++].strName)
  {
    if (g_pMatHolder[pos-1].strParent)
      free(g_pMatHolder[pos-1].strParent);
    free(g_pMatHolder[pos-1].strName);
  }
  delete[] g_pMatHolder;
  g_pMatHolder = NULL;

  return 0;
}


